# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CT_cli_utils;
# "@(#)46   1.18   src/rsct/cli/pm/CT_cli_utils.pm.perl, ctcli, rsct_rzauh, rzauh0431a 11/3/03 13:34:36"
######################################################################
#                                                                    #
# Package: CT_cli_utils.pm                                           #
#                                                                    #
# Description:                                                       #
#   This Perl Module / Package contains utility/common subroutines   #
#   for the Perl RSCT Commands.                                      #
#   Note: Do not place utilities in here that reference the CT::CT   #
#   Perl to C extensions. This module will be used by commands that  #
#   do not need to use the CT::CT perl to C extensions and will not  #
#   want the extra Perl overhead of loading those extensions.        #
#                                                                    #
# Subroutines Available:                                             #
#   printCIMsg          - Use $LSMSG to print general ctcli          #
#                         information messages.                      #
#                                                                    #
#   printCEMsg          - Use $LSMSG to print general ctcli          #
#                         error messages.                            #
#                                                                    #
#   printIMsg           - Uses the calling commands:                 #
#                         $main::LSMSG, $main::PROGNAME,             #
#                         $main::MSGCAT to print command specific    #
#                         informational messages.                    #
#                                                                    #
#   printEMsg           - Uses the calling commands:                 #
#                         $main:LSMSG, $main::PROGNAME,              #
#                         $main::MSGCAT to print command specific    #
#                         error messages.                            #
#                                                                    #
# Examples:                                                          #
#   printCEMsg("EMsgCTcliInputError", $input_line);                  #
#                                                                    #
#--------------------------------------------------------------------#
# Inputs:                                                            #
#   None.                                                            #
#                                                                    #
# Outputs:                                                           #
#   None.                                                            #
#                                                                    #
# External References:                                               #
#   Commands:   $LSMSG                                               #
#   Variables:  $main::PROGNAME         in  Name of calling command. #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   000900 SAB XXXXX: Initial design and write.                      #
#   010202 SAB 71115: Moved data type stuff to CT_cli_data_types.pm  #
#   031020 JAC 100623: Check for certain distros (hopefully temp).   #
#   031103 JAC 100977: Change the KERNEL level.                      #
######################################################################

use Exporter ();
@ISA = qw(Exporter);
@EXPORT_OK = qw(
    printCEMsg
    printCIMsg  
    printIMsg
    printEMsg
);

use locale;
use lib "/usr/sbin/rsct/pm";


#--------------------------------------------------------------------#
# Global Variables                                                   #
#--------------------------------------------------------------------#
$MSGCAT = "ctcli.cat";                 # Msg catalogue for this cmd
$MSGSET = "ctcli";                     # Common message set

# set LD_ASSUME_KERNEL if running on RHEL3
my $rh_relfile = "/etc/redhat-release";
my $rh_vers = '^Red Hat Enterprise Linux .* release 3 (.*)$';
if (-f $rh_relfile){
   `/bin/grep \"$rh_vers\" $rh_relfile > /dev/null 2>&1`;
   my $rhexit = $? >> 8;
   if ($rhexit == 0){
      $ENV{'LD_ASSUME_KERNEL'}="2.4.19";
   }
}

$CTDIR = "/usr/sbin/rsct";             # Cluster directory path
$CTBINDIR = "$CTDIR/bin";              # Cluster Bin directory path
$LSMSG = "$CTBINDIR/ctdspmsg";         # Display message rtn.
$ENV{'MSGMAPPATH'} = "$CTDIR/msgmaps"; # Msg map path for $LSMSG   


#--------------------------------------------------------------------#
# Exported Subroutines (with @EXPORT_OK, -> on demand).              #
#--------------------------------------------------------------------#

#--------------------------------------------------------------------#
# printCEMsg : Calls $LSMSG to print out the common system           #
#   registry cli error messages with the required paramaters.        #
#   Messages printed to stderr.                                      #
#   This subroutine is like printEMsg except it is used to print     #
#   the common CT CLI messages which are in the ctcli message set    #
#   and it prefixes the message with the appropriate program name.   #
#                                                                    #
# Paramaters:                                                        #
#   msg         Message mnemonic / message number in a sense.        #
#   optargs     Extra arguments/parameters to send to LSMSG.         #
#                                                                    #
# Returns:  None.                                                    #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace    in  Prints extra info when trace is on.          #
#   $main::PROGNAME in  Calling program/command for error message.   #
#   $LSMSG          in  Path and command to display messages.        #
#   $MSGCAT         in  CT CLI Message catalogue.                    #
#   $MSGSET         in  CT CLI common message set "ctcli".           #
#--------------------------------------------------------------------#
sub printCEMsg
{
my ($msg, @optargs) = @_; 
my ($optarg, $optargs); 

$main::Trace &&
  print STDERR "$LSMSG $MSGSET $MSGCAT $msg $main::PROGNAME @optargs\n";

# Keep the args to LSMSG separate by separating with single quotes
# but must replace internal single quotes with blanks or get an error.
# Must escape internal double quotes for the system call.
foreach $optarg (@optargs) {
    $optarg =~ s/'/ /g;
    $optarg =~ s/"/\\"/g;
}
$optargs = "'" . join("' '",@optargs) . "'";

(scalar @optargs > 0) ?
    system "$LSMSG $MSGSET $MSGCAT $msg $main::PROGNAME $optargs 1>&2" :
    system "$LSMSG $MSGSET $MSGCAT $msg $main::PROGNAME 1>&2";

return;
}   # end printCEMsg


#--------------------------------------------------------------------#
# printCIMsg : Calls $LSMSG to print out the common system           #
#   registry cli informational messages with the required paramaters.#
#   Messages printed to stdout.                                      #
#   This subroutine is like printIMsg except it is used to print     #
#   the common CT CLI messages which are in the ctcli message set.   #
#                                                                    #
# Paramaters:                                                        #
#   msg       in  Message mnemonic / message number in a sense.      #
#   optargs   in  Extra arguments/parameters to send to LSMSG.       #
#                                                                    #
# Returns:  None.                                                    #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace    in  Prints extra info when trace is on.          #
#   $LSMSG          in  Path & Command to display messages.          #
#   $MSGCAT         in  CT CLI Message catalogue.                    #
#   $MSGSET         in  CT CLI common message set "ctcli".           #
#--------------------------------------------------------------------#
sub printCIMsg
{
my ($msg, @optargs) = @_;
my ($optarg, $optargs);

$main::Trace &&
    print STDERR "$LSMSG $MSGSET $MSGCAT $msg @optargs\n";

# Keep the args to LSMSG separate by separating with single quotes
# but must replace internal single quotes with blanks or get an error.
# Must escape internal double quotes for the system call.
foreach $optarg (@optargs) {
    $optarg =~ s/'/ /g;
    $optarg =~ s/"/\\"/g;
}
$optargs = "'" . join("' '",@optargs) . "'";

(scalar @optargs > 0) ?
    system "$LSMSG $MSGSET $MSGCAT $msg $optargs" :
    system "$LSMSG $MSGSET $MSGCAT $msg";

return;
}   # end printCIMsg


#--------------------------------------------------------------------#
# printIMsg : calls $LSMSG to print out the message with the         #
#   required paramaters, no sense hard coding them all over.         #
#   Messages printed to stdout.                                      #
#                                                                    #
# Paramaters:                                                        #
#   msg       in  Message mnemonic / message number in a sense.      #
#   optargs   in  Extra arguments/parameters to send to LSMSG.       #
#                                                                    #
# Returns:  None.                                                    #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace    in  Print extra info when trace is on.           #
#   $main::PROGNAME in  Calling program/command for error message.   #
#   $main::LSMSG    in  Path & Command to display messages.          #
#   $main::MSGCAT   in  The calling commands Message catalogue.      #
#--------------------------------------------------------------------#
sub printIMsg
{
my ($msg, @optargs) = @_;
my ($optarg, $optargs);

$main::Trace &&
    print STDERR "$main::LSMSG $main::PROGNAME $main::MSGCAT $msg @optargs\n";

# Keep the args to LSMSG separate by separating with single quotes
# but must replace internal single quotes with blanks or get an error.
# Must escape internal double quotes for the system call.
foreach $optarg (@optargs) {
    $optarg =~ s/'/ /g;
    $optarg =~ s/"/\\"/g;
}
$optargs = "'" . join("' '",@optargs) . "'";

(scalar @optargs > 0) ? 
    system "$main::LSMSG $main::PROGNAME $main::MSGCAT $msg $optargs" :
    system "$main::LSMSG $main::PROGNAME $main::MSGCAT $msg";

return;
}   # end printIMsg


#--------------------------------------------------------------------#
# printEMsg : calls $LSMSG to print out the message with the         #
#   required paramaters, no sense hard coding them all over.         #
#   Messages printed to stderr.                                      #
#   The difference between this function and printCEMsg is this      #
#   function uses the calling commands Message catalogue and set.    #
#                                                                    #
# Paramaters:                                                        #
#   msg       in  Message mnemonic / message number in a sense.      #
#   optargs   in  Extra arguments/parameters to send to LSMSG.       #
#                                                                    #
# Returns:  None.                                                    #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace    in  Print extra info when trace is on.           #
#   $main::PROGNAME in  Calling program/command for error message.   #
#   $main::LSMSG    in  Path & Command to display messages.          #
#   $main::MSGCAT   in  The calling commands Message catalogue.      #
#--------------------------------------------------------------------#
sub printEMsg
{
my ($msg, @optargs) = @_;
my ($optarg, $optargs);

$main::Trace &&
    print STDERR "$main::LSMSG $main::PROGNAME $main::MSGCAT $msg @optargs\n";

# Keep the args to LSMSG separate by separating with single quotes
# but must replace internal single quotes with blanks or get an error.
# Must escape internal double quotes for the system call.
foreach $optarg (@optargs) {
    $optarg =~ s/'/ /g;
    $optarg =~ s/"/\\"/g;
}
$optargs = "'" . join("' '",@optargs) . "'";

(scalar @optargs > 0) ?
    system "$main::LSMSG $main::PROGNAME $main::MSGCAT $msg $main::PROGNAME $optargs 1>&2" :
    system "$main::LSMSG $main::PROGNAME $main::MSGCAT $msg $main::PROGNAME 1>&2";

return;
}   # end printEMsg


#--------------------------------------------------------------------#
# End Exported Subroutines (with @EXPORT_OK, -> on demand).          #
#--------------------------------------------------------------------#

#--------------------------------------------------------------------#
# End File                                                           #
#--------------------------------------------------------------------#
